#version 120








/*

                                      █████████   ███████████   ████████████   ██████████   ██
									  █████████   ███████████   ████████████   ██████████   ██
                                      ██               ██       ██        ██   ██      ██   ██
                                      ██               ██       ██        ██   ██      ██   ██
                                      █████████        ██       ██        ██   ██████████   ██
									  █████████        ██       ██        ██   ██████████   ██
                                             ██        ██       ██        ██   ██           ██
	                                         ██        ██       ██        ██   ██           
                                      █████████        ██       ████████████   ██           ██
									  █████████        ██       ████████████   ██           ██

                                           Stop doing anything! Read first the agreement!
										   
                                Please read this agreement carefully:

                                      • You are allowed to make videos or pictures with my shaderpack.
                                      • You are allowed to modify it ONLY for yourself!
                                      • If you donated me, please DON’T share my MediaFire link!
                                      • You are not allowed to claim my shaderpack as your own!
                                      • You are not allowed to redistribute it!
                                      • If you like to share my shaderpack, please share ONLY the dedelner.net link!
                                      • You are not allowed to publish your modifications!
                                      • You are not allowed to reupload it!
                                      • You are not allowed to earn money with it!
									  
                                For YouTube:
                                      • You are allowed to earn money with my shaderpack in your YouTube video.
                                      • If you modified something or use my development shaderpacks, please say that in your YouTube Video or description.

                                Please consider my agreement.
                                    - Thank you.
									
								Last change at: 23. August 2014

*/











/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////SETTINGS////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //#define DEPTH_OF_FIELD
	
	#define LENS_EFFECTS
	
	
	
	
	
	
	
	
	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////GET MATERIAL////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

varying vec4 texcoord;
varying vec3 sunlight;

uniform sampler2D depthtex0;
uniform sampler2D depthtex2;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
vec3 sunPos = sunPosition;
uniform int fogMode;

float ifRain = clamp(wetness, 0.0f, 1.0f)/1.0f;

float timefract = worldTime;
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float TimeDay = TimeSunrise + TimeNoon + TimeSunset;

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#ifdef DEPTH_OF_FIELD

const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
									vec2(  0.0000,  0.2500 ),
									vec2( -0.2165,  0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2(  0.2165, -0.1250 ),
									vec2(  0.4330,  0.2500 ),
									vec2(  0.0000,  0.5000 ),
									vec2( -0.4330,  0.2500 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.0000, -0.5000 ),
									vec2(  0.4330, -0.2500 ),
									vec2(  0.6495,  0.3750 ),
									vec2(  0.0000,  0.7500 ),
									vec2( -0.6495,  0.3750 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.0000, -0.7500 ),
									vec2(  0.6495, -0.3750 ),
									vec2(  0.8660,  0.5000 ),
									vec2(  0.0000,  1.0000 ),
									vec2( -0.8660,  0.5000 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.0000, -1.0000 ),
									vec2(  0.8660, -0.5000 ),
									vec2(  0.2163,  0.3754 ),
									vec2( -0.2170,  0.3750 ),
									vec2( -0.4333, -0.0004 ),
									vec2( -0.2163, -0.3754 ),
									vec2(  0.2170, -0.3750 ),
									vec2(  0.4333,  0.0004 ),
									vec2(  0.4328,  0.5004 ),
									vec2( -0.2170,  0.6250 ),
									vec2( -0.6498,  0.1246 ),
									vec2( -0.4328, -0.5004 ),
									vec2(  0.2170, -0.6250 ),
									vec2(  0.6498, -0.1246 ),
									vec2(  0.6493,  0.6254 ),
									vec2( -0.2170,  0.8750 ),
									vec2( -0.8663,  0.2496 ),
									vec2( -0.6493, -0.6254 ),
									vec2(  0.2170, -0.8750 ),
									vec2(  0.8663, -0.2496 ),
									vec2(  0.2160,  0.6259 ),
									vec2( -0.4340,  0.5000 ),
									vec2( -0.6500, -0.1259 ),
									vec2( -0.2160, -0.6259 ),
									vec2(  0.4340, -0.5000 ),
									vec2(  0.6500,  0.1259 ),
									vec2(  0.4325,  0.7509 ),
									vec2( -0.4340,  0.7500 ),
									vec2( -0.8665, -0.0009 ),
									vec2( -0.4325, -0.7509 ),
									vec2(  0.4340, -0.7500 ),
									vec2(  0.8665,  0.0009 ),
									vec2(  0.2158,  0.8763 ),
									vec2( -0.6510,  0.6250 ),
									vec2( -0.8668, -0.2513 ),
									vec2( -0.2158, -0.8763 ),
									vec2(  0.6510, -0.6250 ),
									vec2(  0.8668,  0.2513 ));
									
#endif
	
float distratio(vec2 pos, vec2 pos2, float ratio) {
    float xvect = pos.x*ratio-pos2.x*ratio;
    float yvect = pos.y-pos2.y;
    return sqrt(xvect*xvect + yvect*yvect);
}
								
float gen_circular_lens(vec2 center, float size) {
    return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,10.0);
}

vec2 noisepattern(vec2 pos) {
    return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}











/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main() {

	vec3 color = texture2D(gaux2, texcoord.st).rgb;

	
	
#ifdef DEPTH_OF_FIELD

    float getdepth = texture2D(depthtex2, texcoord.st).x;

    float depth_fading = centerDepthSmooth;
    float getfocus = (getdepth - depth_fading) / 10;	
	
    float vignette_blur = distance(texcoord.st, vec2(0.5, 0.5));
    vignette_blur = 0.71 - vignette_blur;
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = vec3(0.0);
	
	float blurStrength = 0.0f;
	if (vignette_blur > 0.500) blurStrength = 0.0;
	if (vignette_blur < 0.500) blurStrength = 0.1;
	if (vignette_blur < 0.475) blurStrength = 0.2;
	if (vignette_blur < 0.450) blurStrength = 0.3;
	if (vignette_blur < 0.425) blurStrength = 0.4;
	if (vignette_blur < 0.400) blurStrength = 0.5;
	if (vignette_blur < 0.375) blurStrength = 0.6;
	
	// Distance blur
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)/15,2.0),0.0,1.0);

	for ( int i = 0; i < 60; i++) {
		    sample = texture2D(gaux2, texcoord.xy + (hex_offsets[i]*getfocus) + ((hex_offsets[i]/vignette_blur/1000)*blurStrength) + (hex_offsets[i]*depth_diff)*vec2(1.0,aspectRatio));
		    bcolor += sample.rgb;
	}
	
	color.rgb = bcolor/60.0;
	
#endif
	
	
	
#ifdef LENS_EFFECTS

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;
		
	// For lens flare
	vec4 tpos2 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos2 = vec4(tpos2.xyz/tpos2.w,1.0);
	vec2 lightPos2 = tpos2.xy/-tpos2.z*0.8;
		lightPos2 = (lightPos2 + 1.0f)/2.0f;
		
	vec4 tpos1 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos1 = vec4(tpos1.xyz/tpos1.w,1.0);
	vec2 lightPos1 = tpos1.xy/-tpos1.z*0.6;
		lightPos1 = (lightPos1 + 1.0f)/2.0f;
		
	vec4 tpos3 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos3 = vec4(tpos3.xyz/tpos3.w,1.0);
	vec2 lightPos3 = tpos3.xy/-tpos3.z*0.35;
		lightPos3 = (lightPos3 + 1.0f)/2.0f;
		
	vec4 tpos4 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos4 = vec4(tpos4.xyz/tpos4.w,1.0);
	vec2 lightPos4 = tpos4.xy/-tpos4.z*0.23;
		lightPos4 = (lightPos4 + 1.0f)/2.0f;
		
	vec4 tpos5 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos5 = vec4(tpos5.xyz/tpos5.w,1.0);
	vec2 lightPos5 = tpos5.xy/-tpos5.z*0.15;
		lightPos5 = (lightPos5 + 1.0f)/2.0f;
		
	vec4 tpos6 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos6 = vec4(tpos6.xyz/tpos6.w,1.0);
	vec2 lightPos6 = tpos6.xy/-tpos6.z*0.2;
		lightPos6 = (lightPos6 + 1.0f)/2.0f;
		
	vec4 tpos7 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos7 = vec4(tpos7.xyz/tpos7.w,1.0);
	vec2 lightPos7 = tpos7.xy/-tpos7.z*0.4;
		lightPos7 = (lightPos7 + 1.0f)/2.0f;
		
	vec4 tpos8 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos8 = vec4(tpos8.xyz/tpos8.w,1.0);
	vec2 lightPos8 = tpos8.xy/-tpos8.z*0.95;
		lightPos8 = (lightPos8 + 1.0f)/2.0f;
		
	vec4 tpos9 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos9 = vec4(tpos9.xyz/tpos9.w,1.0);
	vec2 lightPos9 = tpos8.xy/-tpos9.z/100;
		lightPos9 = (lightPos9 + 1.0f)/2.0f;

    float xdist = abs(lightPos.x-texcoord.x);
    float ydist = abs(lightPos.y-texcoord.y);
    float xydist = distance(lightPos.xy,texcoord.xy);
    float xydistratio = distratio(lightPos.xy,texcoord.xy,aspectRatio);
    float xydistratio2 = distratio(lightPos2.xy,texcoord.xy,aspectRatio);
    float xydistratio1 = distratio(lightPos1.xy,texcoord.xy,aspectRatio);
    float xydistratio3 = distratio(lightPos3.xy,texcoord.xy,aspectRatio);
    float xydistratio4 = distratio(lightPos4.xy,texcoord.xy,aspectRatio);
    float xydistratio5 = distratio(lightPos5.xy,texcoord.xy,aspectRatio);
    float xydistratio6 = distratio(lightPos6.xy,texcoord.xy,aspectRatio);
    float xydistratio7 = distratio(lightPos7.xy,texcoord.xy,aspectRatio);
    float xydistratio8 = distratio(lightPos8.xy,texcoord.xy,aspectRatio);	
    float xydistratio9 = distratio(lightPos9.xy,texcoord.xy,aspectRatio);	

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
    float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13000.0)/500.0,0.0,1.0) + clamp((time-22500.0)/100.0,0.0,1.0)-clamp((time-23300.0)/200.0,0.0,1.0));

    float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * fading * transition_fading;
	
    float dirtylens = 0.0;

    vec2 pos1 = noisepattern(vec2(0.6,-0.12));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.3,-0.4));
    dirtylens += gen_circular_lens(pos1,0.015)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.8,-0.4));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.2));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.6));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.2,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.5,-0.9));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.5,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.6,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.7,-0.1));
    dirtylens += gen_circular_lens(pos1,0.035)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.1));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.2,-0.2));
    dirtylens += gen_circular_lens(pos1,0.037)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.4,-0.2));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.95,-0.8));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.99,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.99,0.99));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.2,0.9));
    dirtylens += gen_circular_lens(pos1,0.043)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.4,0.99));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.69,0.999));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.69,0.99));
    dirtylens += gen_circular_lens(pos1,0.025)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.1,0.1));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.1,0.15));
    dirtylens += gen_circular_lens(pos1,0.035)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.15,0.13));
    dirtylens += gen_circular_lens(pos1,0.025)*sunvisibility;
	
	if (sunvisibility > 0.1) {
        float visibility = max(pow(max(1.0 - xydistratio/1.0,0.1),2.0)-0.1,0.0);
	    color += (dirtylens*visibility)*0.15*TimeDay*(1.0-ifRain*1.0);
		color += (dirtylens*visibility)*vec3(0.25, 0.5, 0.7)*0.1*TimeMidnight*(1.0-ifRain*1.0);
	}

if ((worldTime < 13000 || worldTime > 23000) && sunPos.z < 0 && isEyeInWater < 0.9){

    if (sunvisibility > 0.1) {
        float ratiolens = max(pow(max(1.0 - xydistratio/1.0,0.1),2.0)-0.1,0.0);
		color += ratiolens*0.2*sunvisibility * (1.0-ifRain*1.0);
    }

    // Anamorphic Lens
    if (ydist < 0.27 && sunvisibility > 0.1) {
	
        float dist = distance(texcoord.st, vec2(0.5, 0.5));
        dist = 0.5 - dist;
	
	    vec3 lenscolor = vec3(0.3, 0.8, 1.5)*1.3*TimeDay;
		
        float anamorphic_lens = max(pow(max(1.0 - ydist/1.412,0.01),8.0)-0.7,0.0);
        color += lenscolor*anamorphic_lens*dist*sunvisibility * (1.0-ifRain*1.0);
    }

	// Big blue point
    if (xydistratio1 < 0.3 && sunvisibility > 0.1) {

	    vec3 lenscolor = vec3(0.3, 0.8, 1.5)*TimeDay;
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
	 
        float lens_flare1 = max(pow(max(1.0 - xydistratio1/1.512,0.1),2.0)-0.93,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-ifRain*1.0);
		
        float lens_flare2 = max(pow(max(1.0 - xydistratio1/1.512,0.1),8.0)-0.95,0.0);
        color += lenscolor*lens_flare2*5.0*sunvisibility * (1.0-ifRain*1.0);
	
        float lens_flare3 = max(pow(max(1.0 - xydistratio1/1.512,0.1),8.0)-0.2,0.0);
        color += lenscolor*lens_flare3*0.1*sunvisibility * (1.0-ifRain*1.0);
    }

    // Red point next to the big blue point
    if (xydistratio2 < 0.3 && sunvisibility > 0.1) {

	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*TimeDay;
		
		float lens_strength = 0.6;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio2/1.412,0.01),2.0)-0.9,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-ifRain*1.0);
    }
	
	// Red point near to the big blue point
    if (xydistratio3 < 0.5 && sunvisibility > 0.1) {
	
	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*TimeDay;
		
		float lens_strength = 0.9;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio3/1.412,0.01),2.0)-0.95,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-ifRain*1.0);

    }
	
	// Red point near to the big blue point
    if (xydistratio4 < 0.5 && sunvisibility > 0.1) {
	
	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*TimeDay;
		
		float lens_strength = 0.6;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio4/1.412,0.01),2.0)-0.9,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-ifRain*1.0);

    }
	
	////////////////////////////////////////////////////////////////////////////////
	
	// Little green point
    if (xydistratio5 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.5, 1.0, 0.2)*TimeDay;
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio5/1.512,0.1),8.0)-0.95,0.0);
        color += lenscolor*lens_flare1*2.0*sunvisibility * (1.0-ifRain*1.0);
	}
	
	// Bigger little blue point
    if (xydistratio8 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.3, 0.8, 1.5)*TimeDay;
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio8/1.512,0.1),8.0)-0.925,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-ifRain*1.0);
	}
	
	// Bigger little blue point near at the sun
    if (xydistratio9 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.3, 0.8, 1.5)*TimeDay;
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio9/1.512,0.1),8.0)-0.925,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-ifRain*1.0);
	}
}
	
//rain drops on screen

if (rainStrength > 0.01) {
    const float pi = 3.14159265359;
	float lightmap = pow(eyeBrightness.y/255.0, 6.0f);
	float fake_refract = 1.0-sin(worldTime/5.14159265359 + texcoord.x*30.0 + texcoord.y*30.0);
	float fake_refract2 = sin(worldTime/7.14159265359 + texcoord.x*20.0 + texcoord.y*20.0) * pow(eyeBrightness.y/255.0, 6.0f) * (1.0-TimeMidnight*0.7);
    vec3 watercolor = texture2D(gaux1, texcoord.st + fake_refract * 0.015 * lightmap).rgb;
    float raindrops = 0.0;
	float time2 = frameTimeCounter;

    float gen = cos(time2*pi)*0.5+0.5;
    vec2 pos = noisepattern(vec2(0.9347*floor(time2*0.5+0.5),-0.2533282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.785282*floor(time2*0.5+0.5),-0.285282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = sin(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(-0.347*floor(time2*0.5+0.5),0.6847*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.3347*floor(time2*0.5+0.5),-0.2533282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.385282*floor(time2*0.5+0.5),-0.285282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;
     
	if (isEyeInWater < 0.9) {
        color += abs(fake_refract2)/25*raindrops;
	}
}

#endif



// vignette

    float dist = distance(texcoord.st, vec2(0.5, 0.5));
    dist = 0.78 - dist;
	
    color.r = color.r * dist;
    color.g = color.g * dist;
    color.b = color.b * dist;
	
	

// color filter

	// vintage
	vec3 vintage_color = vec3(2.32, 2.23, 1.85); 
	vec3 second_color = vec3(0.0, 0.005, 0.01);
	
	//color = color * vintage_color + second_color;
	
	// gamma
	color.r = pow(color.r, 0.8);
	color.g = pow(color.g, 0.8);
	color.b = pow(color.b, 0.8);
	
	// brightness
	color = color * 1.5;
	
    vec3 Gray = vec3(0.0, 0.3, 0.3);
    vec3 ColorScale = vec3(1.0, 1.0, 1.0);
    float Saturation = 1.8;

    // Color Matrix
    vec3 OutColor = color.rgb;
    
    // Offset & Scale
    OutColor = (OutColor * ColorScale);
    
    // Saturation
    float Luma = dot(OutColor, Gray);
    vec3 Chroma = OutColor - Luma;
    OutColor = (Chroma * Saturation) + Luma;
    
    color = OutColor;

	
	
    color = clamp(color,0.0,1.0);
    float white = luma(color);
    color = color*(1.0+pow(white,0.3))/(2.0-0.3);

	
	
// tonemap
    color = color / (color + 1.0) * (1.0+1.0);


	
    color = pow(color,vec3(2.2));
    color = pow(color,vec3(1.0/2.2));
	gl_FragColor = vec4(color,1.0);
	
}
