#version 120








/*

                                      █████████   ███████████   ████████████   ██████████   ██
									  █████████   ███████████   ████████████   ██████████   ██
                                      ██               ██       ██        ██   ██      ██   ██
                                      ██               ██       ██        ██   ██      ██   ██
                                      █████████        ██       ██        ██   ██████████   ██
									  █████████        ██       ██        ██   ██████████   ██
                                             ██        ██       ██        ██   ██           ██
	                                         ██        ██       ██        ██   ██           
                                      █████████        ██       ████████████   ██           ██
									  █████████        ██       ████████████   ██           ██

                                           Stop doing anything! Read first the agreement!
										   
                                Please read this agreement carefully:

                                      • You are allowed to make videos or pictures with my shaderpack.
                                      • You are allowed to modify it ONLY for yourself!
                                      • If you donated me, please DON’T share my MediaFire link!
                                      • You are not allowed to claim my shaderpack as your own!
                                      • You are not allowed to redistribute it!
                                      • If you like to share my shaderpack, please share ONLY the dedelner.net link!
                                      • You are not allowed to publish your modifications!
                                      • You are not allowed to reupload it!
                                      • You are not allowed to earn money with it!
									  
                                For YouTube:
                                      • You are allowed to earn money with my shaderpack in your YouTube video.
                                      • If you modified something or use my development shaderpacks, please say that in your YouTube Video or description.

                                Please consider my agreement.
                                    - Thank you.
									
								Last change at: 23. August 2014


*/











/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////SETTINGS////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    #define DYNAMIC_HANDLIGHT
	
    //#define SHADOW_FILTER
	
	#define WATER_REFRACT
	
	//#define SSAO
	
	//#define CEL_SHADING                    // Not compatible with SSAO
	
	//#define CLOUDS
	
	#define BETTER_SUN
	
	#define FOG
	
	//#define GODRAYS

	
	
	
	
	
	
	
	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONSTS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Don't touch these values, if you don't know, what you do!
const int       shadowMapResolution     = 256;
const bool 		generateShadowMipmap 	= false;
const float 	centerDepthHalflife 	= 2.0f;
const float 	shadowIntervalSize 		= 4.0f;
const float     shadowDistance          = 80.0f;
const float	    sunPathRotation	        = -35.0f;
const float	    ambientOcclusionLevel   = 1.0f;
const float 	wetnessHalflife 		= 1.0f; // Wet to dry.
const float 	drynessHalflife 		= 1.0f;  // Dry ro wet.

#define SHADOW_MAP_BIAS 0.85

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////GET MATERIAL / VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D gnormal;
uniform sampler2D shadow;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D noisetex;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float wetness;
uniform float aspectRatio;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float rainStrength2 = clamp(wetness, 0.0f, 1.0f)/1.0f;

float timefract = worldTime;
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay = TimeSunrise + TimeNoon + TimeSunset;

#ifdef CLOUDS

    #define pi 3.14159265
    #define R(p, a) p=cos(a)*p+sin(a)*vec2(p.y, -p.x)
    #define hsv(h,s,v) mix(vec3(1.), clamp((abs(fract(h+vec3(3., 2., 1.)/3.)*6.-3.)-1.), 0., 1.), s)*v

    float pn(vec3 p) {
        vec3 i = floor(p);
        vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
        vec3 f = cos((p-i)*pi)*(-.5) + .5;
        a = mix(sin(cos(a)*a), sin(cos(1.+a)*(1.+a)), f.x);
        a.xy = mix(a.xz, a.yw, f.y);
        return mix(a.x, a.y, f.z);
    }

    float fpn(vec3 p) {
        return pn(p*.06125)*.5 + pn(p*.125)*.25 + pn(p*.25)*.125;
    }

    float sphere( vec3 p ) {
        return length(p) - 0.55;
    }

    float spheres( vec3 p ) {
        float day = 1.0*TimeDay*(1.0-rainStrength2*1.0);
        float night = 0.3*TimeMidnight*(1.0-rainStrength2*1.0);
	    float rain = 0.27*rainStrength2;
	    float scale = day + rain +  night;
	    return sphere(scale*vec3(sin(p.x + sin(p.x)*sin(p.z) + 0.08*frameTimeCounter),p.y + 4.0, -sin(p.z + 0.08*frameTimeCounter))* 0.7) / scale;	
    }

    float f(vec3 p) {
        R(p.xy, pi);
        R(p.xz, 0.0);
        return spheres(p) +  fpn(p*45.) * 0.125;
    }

#endif

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float distratio(vec2 pos, vec2 pos2, float ratio) {
    float xvect = pos.x*ratio-pos2.x*ratio;
    float yvect = pos.y-pos2.y;
    return sqrt(xvect*xvect + yvect*yvect);
}

float gen_circular_lens(vec2 center, float size) {
    return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,10.0);
}

vec2 noisepattern(vec2 pos) {
    return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 sunPos = sunPosition;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
float shadowexit = 0.0;

float handlight = handItemLight;
float lightmap = pow(aux.r,3.0);
float torch_skylightmap = pow(aux.r,1.0);
float sky_lightmap = pow(aux.r,10.0);

#ifdef SSAO

    float pw = 1.0/ viewWidth *4;
    float ph = 1.0/ viewHeight *4;

    float readDepth( vec2 coord );
    float readDepth(vec2 coord) {
        return 2.0 * near * far / (far + near - (2.0 * texture2D(depthtex0, coord).x - 1.0) * (far - near));
    }
	
#else

    float pw = 1.0/ viewWidth;
    float ph = 1.0/ viewHeight;
	
#endif

#ifdef SHADOW_FILTER

    // circle distribution for shadow filter
    const vec2 circle_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);			
									
#endif


						
#ifdef CEL_SHADING

    #define border 1.3

    vec3 celshade(vec3 clrr) {
	    //edge detect
	    float d = edepth(texcoord.xy);
	    float dtresh = 1/(far-near)/5000.0;	
	    vec4 dc = vec4(d,d,d,d);
	    vec4 sa;
	    vec4 sb;
	    sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*border);
	    sa.y = edepth(texcoord.xy + vec2(pw,-ph)*border);
	    sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*border);
	    sa.w = edepth(texcoord.xy + vec2(0.0,ph)*border);
	
	    //opposite side ssao_samples
	    sb.x = edepth(texcoord.xy + vec2(pw,ph)*border);
	    sb.y = edepth(texcoord.xy + vec2(-pw,ph)*border);
	    sb.z = edepth(texcoord.xy + vec2(pw,0.0)*border);
	    sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*border);
	
	    vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
	    dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
	
	    float e = clamp(dot(dd,vec4(0.5f,0.5f,0.5f,0.5f)),0.0,1.0);
	    return clrr*e;
    }
	
#endif



#ifdef GODRAYS
    float getnoise(vec2 pos) {
        return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
    }
#endif

#ifdef WATER_REFRACT

    float waterH(vec3 posxz) {

        float wave = 0.0;

        float factor = 1.0;
        float amplitude = 0.2;
        float speed = 4.0;
        float size = 0.2;

        float px = posxz.x/50.0 + 250.0;
        float py = posxz.z/50.0  + 250.0;

        float fpx = abs(fract(px*20.0)-0.5)*2.0;
        float fpy = abs(fract(py*20.0)-0.5)*2.0;

        float d = length(vec2(fpx,fpy));

        for (int i = 1; i < 8; i++) {
            wave -= d*factor*cos( (1/factor)*px*py*size + 1.0*frameTimeCounter*speed);
            factor /= 2;
        }

        factor = 1.0;
        px = -posxz.x/50.0 + 250.0;
        py = -posxz.z/150.0 - 250.0;

        fpx = abs(fract(px*20.0)-0.5)*2.0;
        fpy = abs(fract(py*20.0)-0.5)*2.0;

        d = length(vec2(fpx,fpy));
        float wave2 = 0.0;
		
        for (int i = 1; i < 8; i++) {
            wave2 -= d*factor*cos( (1/factor)*px*py*0.4 + 1.0*frameTimeCounter*6.0);
            factor /= 2;
        }

        return amplitude*wave2+amplitude*wave;
    }
	
#endif











/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main() {

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
	
	#ifndef DYNAMIC_HANDLIGHT
	    handlight = 0.0;
	#endif

	float shadowexit = float(aux.g > 0.1 && aux.g < 0.3);
	float land = float(aux.g > 0.03);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);
	
	vec3 color = texture2D(gcolor, texcoord.st).rgb;
	color = pow(color,vec3(2.2));
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
	vec4 worldposition = vec4(0.0);
	vec4 worldpositionraw = vec4(0.0);
	worldposition = gbufferModelViewInverse * fragposition;	
	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;
	worldpositionraw = worldposition;
		
	float shading = 1.0f;
	float spec = 0.0;
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13000.0)/500.0,0.0,1.0) + clamp((time-23000.0)/100.0,0.0,1.0)-clamp((time-23300.0)/200.0,0.0,1.0));	//fading between sun/moon shadows

	#ifdef WATER_REFRACT
	
	    if (iswater > 0.99) {
	
	        vec3 posxz = worldposition.xyz;
	
	        float deltaPos = 0.1;
	        float h0 = waterH(posxz);
	        float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	        float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	        float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	        float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	        float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	        float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	        float refMult = 0.005-dot(normal,normalize(fragposition).xyz)*0.0015;
	
	        vec3 refract = normalize(vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta));
	        vec4 rA = texture2D(gcolor, texcoord.st + refract.xy*refMult);
	        rA.rgb = pow(rA.rgb,vec3(2.2));
	        vec4 rB = texture2D(gcolor, texcoord.st);
	        rB.rgb = pow(rB.rgb,vec3(2.2));
	        float mask = texture2D(gaux1, texcoord.st + refract.xy*refMult).g;
	        mask =  float(mask > 0.04 && mask < 0.07);
	        color = rA.rgb*mask + rB.rgb*(1-mask);
	    }	
		
	#endif
	
	if (land > 0.9 && isEyeInWater < 0.1) {
	
	float dist = length(fragposition.xyz);

	float shadingsharp = 0.0f;

	vec4 worldposition = vec4(0.0);
	vec4 worldpositionraw = vec4(0.0);
	worldposition = gbufferModelViewInverse * fragposition;	
	
	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;
	
	worldpositionraw = worldposition;
	worldposition = shadowModelView * worldposition;
	float comparedepth = -worldposition.z;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	
	float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy *= 1.0f / distortFactor;
	worldposition = worldposition * 0.5f + 0.5f;
	int vpsize = 0;
	float diffthresh = 1.0*distortFactor+iswater+translucent;
	float isshadow = 0.0;
	float ssample;

	float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
	float distof2 = clamp(1.0-dist/(shadowDistance*0.75),0.0,1.0);
	float shadow_fade = clamp(distof*12.0,0.0,1.0);
	float sss_fade = pow(distof2,0.2);
	float step = 1.0/shadowMapResolution;
	
		if (dist < shadowDistance) {

			if (shadowexit > 0.1) {
				shading = 1.0;
			} else {
			
				#define shadow_brightmult 200.0
			
			#ifdef SHADOW_FILTER
					
				for(int i = 0; i < 25; i++){
				    if (iswater > 0.9) {
					    shadingsharp += (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + circle_offsets[i]*step*10.0).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));						
				    } else {
					    shadingsharp += (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + circle_offsets[i]*step).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));
				    }
				}
					
				shadingsharp /= 25.0;
				shading = 1.0-shadingsharp;
				isshadow = 1.0;
			
			#else
			
				shading = (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st).z) * (256.0 - 0.05)), 0.0, diffthresh)/(diffthresh));
				shading = 1.0-shading;
				
			#endif
			
			}
		}
		
	float ao = 1.0;
	
	
	
#ifdef SSAO

    float depth = readDepth(texcoord.xy);
    float d;

    float ssaoCap = 0.95;
    float ssao = 0.0;
    float ssaoMultiplier=250.0;
    float depthTolerance = 0.01;
   
    d=readDepth( vec2(texcoord.x+pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x+pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);
   
    pw*=2.0;
    ph*=2.0;
    ssaoMultiplier/=2.0;

    d=readDepth( vec2(texcoord.x+pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x+pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    pw*=2.0;
    ph*=2.0;
    ssaoMultiplier/=2.0;

    d=readDepth( vec2(texcoord.x+pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x+pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    pw*=2.0;
    ph*=2.0;
    ssaoMultiplier/=2.0;

    d=readDepth( vec2(texcoord.x+pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y+ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x+pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    d=readDepth( vec2(texcoord.x-pw,texcoord.y-ph));
    ssao+=min(ssaoCap,max(0.0,depth-d-depthTolerance) * ssaoMultiplier);

    ssao/=16.0;
   
    color = (1.0-ssao) * color;

#endif



// Add custom sunlightcolor/shadowcolor
	
    vec3 sunlight_sunrise = vec3(0.61, 0.23, 0.09) * TimeSunrise;
    vec3 sunlight_noon = vec3(1.0, 1.0, 1.0) * TimeNoon;
    vec3 sunlight_sunset = vec3(0.61, 0.2, 0.05) * TimeSunset;
    vec3 sunlight_midnight = vec3(0.2, 0.4, 0.7) * 0.2 * (TimeMidnight);
	vec3 sunlight_color = sunlight_sunrise + sunlight_noon + sunlight_sunset + (sunlight_midnight);

	vec3 shadowcolor_day = vec3(1.3, 2.0, 2.55) * (TimeSunrise+TimeSunset);
	vec3 shadowcolor_noon = vec3(0.6, 1.8, 2.55) * 2.0 * TimeNoon;
	vec3 shadowcolor_night = vec3(1.5, 2.55, 2.55) * 4.0 * TimeMidnight;
	vec3 shadowcolor_rain = vec3(1.5, 2.0, 2.2)*2.5*rainStrength2*(1.0-TimeMidnight*0.75);
	vec3 shadowcolor = shadowcolor_day + shadowcolor_noon + shadowcolor_night + shadowcolor_rain;
	
	vec3 sunlight_water_day = vec3(1.0,1.6,2.55)*0.15 * TimeDay * (1.0-(TimeSunrise+TimeSunset)*0.5);
	vec3 sunlight_water_night = vec3(0.8,1.4,2.55)*0.03 * TimeMidnight;
	vec3 water_sunlight_color = sunlight_water_day + sunlight_water_night;
	
	vec3 water_shadowcolor_day = vec3(0.5, 1.3, 2.2)*0.3*TimeDay;
	vec3 water_shadowcolor_night = vec3(0.4, 1.8, 2.0)*1.5*TimeMidnight;
	vec3 water_shadowcolor_rain = vec3(0.6, 1.6, 2.55)*0.5*rainStrength2;
	vec3 water_shadowcolor = water_shadowcolor_day + water_shadowcolor_night + water_shadowcolor_rain;
	
	vec3 sss_color_day = vec3(1.0, 0.15, 0.05)*(TimeSunrise+TimeSunset)*(1.0 - rainStrength2 * 1.0);
	vec3 sss_color_noon = vec3(1.0, 1.0, 1.0)*TimeNoon*(1.0 - rainStrength2 * 1.0);
	
	vec3 sss_color = sss_color_day + sss_color_noon;
	
	float sss_transparency = mix(0.0,1.0,translucent);		//subsurface scattering amount
	float sunlight_direct = 1.0;
	float direct = 1.0;
	float sss = 0.0;
	vec3 npos = normalize(fragposition.xyz);
	float NdotL = 1.0;
	NdotL = dot(normal, lightVector);
	direct = NdotL;
		
	sunlight_direct = max(direct,0.0);
	sunlight_direct = mix(sunlight_direct,1.0,translucent*min(sss_fade+0.4,1.0));
	
	sss += pow(max(dot(npos, lightVector),0.0),10.0)*sss_transparency*clamp(-NdotL,0.0,1.0)*translucent*(1.0 - rainStrength2*1.0);
	sss = mix(0.0,sss,sss_fade);
	
	shading = clamp(shading,0.0,1.0);
	
		
		
// Apply different lightmaps to image
	
	#define sunlight_amount 0.4

	vec3 Sunlight_lightmap = sunlight_color*mix(max(lightmap-rainStrength2*1.0,0.0),shading,shadow_fade)*sunlight_amount*(1.0-rainStrength2*1.0)*sky_lightmap *sunlight_direct*transition_fading ;
	vec3 water_sunlight_lightmap = water_sunlight_color*mix(max(lightmap-rainStrength2*1.0,0.0),shading,shadow_fade)*sunlight_amount*(1.0-rainStrength2*1.0)*sky_lightmap*transition_fading ;
		
	// Desaturate ambient color at night.
    vec3 Gray = vec3(0.3, 0.3, 0.3);
    vec3 ColorScale = vec3(1.0, 1.0, 1.0);
    float saturation_day = 1.0*TimeDay;
    float saturation_night = 0.5*TimeMidnight;
	
	float saturation = saturation_day + saturation_night;

    // Color Matrix
    vec3 OutColor = color.rgb;
    
    // Offset & Scale
    OutColor = (OutColor * ColorScale);
    
    // Saturation
    float Luma = dot(OutColor, Gray);
    vec3 Chroma = OutColor - Luma;
    OutColor = (Chroma * saturation) + Luma;
    
    vec3 nolight = OutColor;
	
	
	float min_light = 0.0;
	
	
	float sky_inc = sqrt(direct*0.5+0.51);
	vec3 amb = (sky_inc*ambient_color+(1.0-sky_inc)*(sunlight_color+ambient_color*2.0)*vec3(0.2,0.24,0.27))*vec3(0.8,0.8,1.0);
	
	float torchlightBrightnessDayOutside     = 5.0*TimeDay*torch_skylightmap;
	float torchlightRangeDayOutside          = 40.0*TimeDay*torch_skylightmap;
	
	float torchlightBrightnessNightOutside   = 0.3*TimeMidnight*torch_skylightmap;
	float torchlightRangeNightOutside        = 7.0*TimeMidnight*torch_skylightmap;
	
	float torchlightBrightnessInside         = 0.015/torch_skylightmap;
	float torchlightRangeInside              = 0.3/torch_skylightmap;
	
	float torchlightHandlightDay             = 40.0*TimeDay*torch_skylightmap;
	float torchlightHandlightNight           = 1.0*TimeMidnight*torch_skylightmap;
	float torchlightHandlightInside          = 0.05/torch_skylightmap;

	
	
	float torchlight_brightness = torchlightBrightnessDayOutside + torchlightBrightnessNightOutside + torchlightBrightnessInside;
	float torchlight_range = torchlightRangeDayOutside + torchlightRangeNightOutside + torchlightRangeInside;
	float torchlight_handlight = torchlightHandlightDay + torchlightHandlightNight + torchlightHandlightInside;
	
    float torch_lightmap = pow(aux.b,torchlight_range)*torchlight_brightness;
	
	vec3 torchcolor = vec3(2.55,0.4,0.12);
	
	vec3 Torchlight_lightmap = (torch_lightmap+handlight*pow(max(8.0-length(fragposition.xyz),0.0)/10.0,4.5)*max(dot(-fragposition.xyz,normal),0.0)/torchlight_handlight) *  torchcolor;
	
    float dirtylens = 0.0;

    vec2 pos1 = noisepattern(vec2(0.6,-0.12));
    dirtylens += gen_circular_lens(pos1,0.05);
	
    pos1 = noisepattern(vec2(0.3,-0.4));
    dirtylens += gen_circular_lens(pos1,0.015);
	
    pos1 = noisepattern(vec2(0.8,-0.4));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(0.9,-0.2));
    dirtylens += gen_circular_lens(pos1,0.03);
	
    pos1 = noisepattern(vec2(0.9,-0.6));
    dirtylens += gen_circular_lens(pos1,0.04);
	
    pos1 = noisepattern(vec2(0.2,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04);
	
    pos1 = noisepattern(vec2(0.5,-0.9));
    dirtylens += gen_circular_lens(pos1,0.05);
	
    pos1 = noisepattern(vec2(0.5,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(0.6,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(0.7,-0.1));
    dirtylens += gen_circular_lens(pos1,0.035);
	
    pos1 = noisepattern(vec2(0.9,-0.1));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(0.2,-0.2));
    dirtylens += gen_circular_lens(pos1,0.037);
	
    pos1 = noisepattern(vec2(0.4,-0.2));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(-0.95,-0.8));
    dirtylens += gen_circular_lens(pos1,0.03);
	
    pos1 = noisepattern(vec2(-0.99,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04);
	
    pos1 = noisepattern(vec2(-0.99,0.99));
    dirtylens += gen_circular_lens(pos1,0.03);
	
    pos1 = noisepattern(vec2(-0.2,0.9));
    dirtylens += gen_circular_lens(pos1,0.043);
	
    pos1 = noisepattern(vec2(-0.4,0.99));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(-0.69,0.999));
    dirtylens += gen_circular_lens(pos1,0.02);
	
    pos1 = noisepattern(vec2(-0.69,0.99));
    dirtylens += gen_circular_lens(pos1,0.025);
	
    pos1 = noisepattern(vec2(-0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.03);
	
    pos1 = noisepattern(vec2(0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.04);
	
    pos1 = noisepattern(vec2(0.1,0.1));
    dirtylens += gen_circular_lens(pos1,0.05);
	
    pos1 = noisepattern(vec2(0.1,0.15));
    dirtylens += gen_circular_lens(pos1,0.035);
	
    pos1 = noisepattern(vec2(0.15,0.13));
    dirtylens += gen_circular_lens(pos1,0.025);
		
	vec3 color_sunlight = Sunlight_lightmap;
	vec3 color_water_sunlight = water_sunlight_lightmap;
	vec3 color_torchlight = Torchlight_lightmap;  
		
// Apply all light elements 

	if (iswater > 0.9) {
		color = (amb/125*water_shadowcolor*lightmap*ao + color_water_sunlight * water_sunlight_color * shading * transition_fading)*nolight + min_light*vec3(0.6, 2.0, 2.55)*color + (color_torchlight*0.2*ao)*color;
	} else {
		color = (amb/shadow_brightmult*shadowcolor*lightmap*ao + color_sunlight * sunlight_color + (sss * sss_color) * shading * transition_fading)*nolight + min_light*vec3(0.6, 2.0, 2.55)*color + dirtylens*0.02*(color_torchlight*ao) + (color_torchlight*ao)*color;
    }
	} else if (isEyeInWater < 0.1){
	 
	    // Desaturate sky colors from resource packs.
        vec3 Gray = vec3(0.3, 0.3, 0.3);
        vec3 ColorScale = vec3(1.0, 1.0, 1.0);
        float Saturation = 0.0;

        // Color Matrix
        vec3 OutColor = color.rgb;
    
        // Offset & Scale
        OutColor = (OutColor * ColorScale);
    
        // desaturation night ambient.
        float Luma = dot(OutColor, Gray);
        vec3 Chroma = OutColor - Luma;
        OutColor = (Chroma * Saturation) + Luma;
		
		color = OutColor;
		
	    vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	    fragposition /= fragposition.w;
	
	    vec4 worldposition = vec4(0.0);
	    worldposition = gbufferModelViewInverse * fragposition;	
		
        float horizont = abs(worldposition.y - texcoord.y);
		float skycolor_position = max(pow(max(1.0 - horizont/(53.0*100.0),0.01),8.0)-0.1,0.0);
		float horizont_position = max(pow(max(1.0 - horizont/(4.0*100.0),0.01),8.0)-0.1,0.0);
	
	    // Add new sky colors.
	    vec3 skycolor_sunrise = vec3(0.4, 0.5, 0.85) * 0.2 * (1.0-rainStrength2*1.0) * TimeSunrise;
	    vec3 skycolor_day = vec3(0.15, 0.35, 0.85) * (1.0-rainStrength2*1.0) * TimeNoon;
	    vec3 skycolor_sunset = vec3(0.4, 0.5, 0.85) * 0.2 * (1.0-rainStrength2*1.0) * TimeSunset;
		vec3 skycolor_night = vec3(0.15, 0.6, 1.3) * 2.0 * TimeMidnight;
		vec3 skycolor_rain = vec3(0.7, 1.2, 2.0)*0.25*rainStrength2;
		color.rgb *= (skycolor_sunrise + skycolor_day + skycolor_sunset + skycolor_night + skycolor_rain) * skycolor_position;
		
	    vec3 horizontColor_sunrise = vec3(1.0, 0.45, 0.3) * 0.12 * (1.0-rainStrength2*1.0) * TimeSunrise;
	    vec3 horizontColor_day = vec3(0.8, 0.9, 1.0) * 0.12 * (1.0-rainStrength2*1.0) * TimeNoon;
	    vec3 horizontColor_sunset = vec3(1.0, 0.3, 0.1) * 0.12 * (1.0-rainStrength2*1.0) * TimeSunset;
	    vec3 horizontColor_rain = vec3(1.0, 1.3, 2.0) * 0.05 * rainStrength2 *(1.0-TimeMidnight*1.0);
		
		vec3 horizontColor = horizontColor_sunrise + horizontColor_day + horizontColor_sunset + horizontColor_rain;
		color.rgb += horizontColor * horizont_position;
		
		#ifdef CLOUDS

        // p: position on the ray.
        // d: direction of the ray.
        vec3 p = vec3(0.,0.,1.2);
        vec3 d = vec3(worldposition.xyz - cameraPosition.xyz/ 2048) + p;
        d = normalize(d); 

        // ld, td: local, total density .
        // w: weighting factor.
        float ld = 0., td = 0.;
        float w = 0.;
   
        // i: 0 <= i <= 1.
        // r: length of the ray.
        // l: distance function.
        float i = 0., r = 0., l = 0., b = 0.;

        // rm loop.
        if (d.y>0.) for (float i=0.; (i<1.); i+=1./5.) {
	        if(!((i<1.) && (l>=0.001*r) && (r < 25.)&& (td <= 1.0))) break;
	   
            // evaluate distance function.
            l = f(p) / 3;
      
            // check whether we are close enough.
            if (l < .1) {
			
                // compute local density and weighting factor.
                ld = 0.1 - l;
                w = (1. - td) * ld;   
				
				// get cloud colors.
				vec3 cloudcolor_sunset = vec3(1.0, 0.65, 0.7)*0.5*TimeSunrise*(1.0-rainStrength2*1.0);
				vec3 cloudcolor_noon = vec3(1.0, 1.0, 1.0)*5.0*TimeNoon*(1.0-rainStrength2*1.0);
				vec3 cloudcolor_sunrise = vec3(1.0, 0.65, 0.7)*TimeSunset*(1.0-rainStrength2*1.0);
				vec3 cloudcolor_midnight = vec3(0.1, 0.4, 1.0)/20.0*TimeMidnight*(1.0-rainStrength2*1.0);
			    vec3 cloudcolor_rain = vec3(0.5,0.8,1.2)*0.2*rainStrength2*(1.0-TimeMidnight*0.97);
				
				vec3 cloudcolor = cloudcolor_sunset + cloudcolor_noon + cloudcolor_sunrise + cloudcolor_midnight + cloudcolor_rain;
				cloudcolor *= (eyeBrightnessSmooth.y/255.0);
				cloudcolor *= 0.25;
				
		        // inject moon into the clouds
		        float volumetric_cone = max(dot(normalize(fragpos),lightVector),0.0);
		        color.rgb += w*cloudcolor_midnight*pow(volumetric_cone,30.0)*5.0;
				
		        color.rgb += cloudcolor*w;
				
            }
			
            td += 1./90.;
      
            // enforce minimum stepsize.
            l = max(l, 0.1);
      
            // step forward.
            p += (l*d)*6;
			r += l;
		
        }
		
        #endif		
		
		
		
		#ifdef BETTER_SUN
		
		// get sun color.
	    vec3 suncolor_day = vec3(1.0, 0.45, 0.3)*(TimeSunrise+TimeSunset)*(1.0 - rainStrength2 * 1.0);
	    vec3 suncolor_noon = vec3(0.3, 0.6, 1.0)*5.5*TimeNoon*(1.0 - rainStrength2 * 1.0);
	    vec3 suncolor_rain = vec3(1.0, 1.3, 2.0)*0.1*rainStrength2 * TimeDay;
        vec3 mooncolor_rain = vec3(0.15, 0.5, 1.0)*0.05*rainStrength2 * TimeMidnight;
	
	    vec3 suncolor = suncolor_day + suncolor_noon;

		// inject sun into the sky.
		float volumetric_cone = max(dot(normalize(fragpos),lightVector),0.0);
		
	        // ambient color.
		    color.rgb += pow(volumetric_cone,3.0)*0.05*suncolor*transition_fading;
			
	        // ambient color at rain.
			color.rgb += pow(volumetric_cone,3.0)*0.3*suncolor_rain*transition_fading;
			
	        // moon ambient color at rain.
		    color.rgb += pow(volumetric_cone,10.0)*0.05*mooncolor_rain*transition_fading;
			
		    // fake sun color.
		    color.rgb += pow(volumetric_cone,300.0)*3.0*suncolor*(1.0 - rainStrength2 * 1.0)*transition_fading;
			
	    #endif
				
	}
	
	
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	
	#ifdef FOG
	
		// get sun color.
	    vec3 suncolor_day = vec3(1.0, 0.45, 0.3)*(TimeSunrise+TimeSunset)*(1.0 - rainStrength2 * 1.0);
	    vec3 suncolor_noon = vec3(0.6, 0.7, 1.0)*TimeNoon*(1.0 - rainStrength2 * 1.0);
	
	    vec3 suncolor = suncolor_day + suncolor_noon;
		
		float volumetric_cone = max(dot(normalize(fragpos),lightVector),0.0);
	
	    // calculate fog distance.
	    float fog_sunrise = 75.0*TimeSunrise*(1.0-rainStrength2*1.0);
	    float fog_normal = 125.0*(TimeNoon+TimeSunset)*(1.0-rainStrength2*1.0);
	    float fog_midnight = 75.0*TimeMidnight*(1.0-rainStrength2*1.0);
	    float fog_rain = 35.0*rainStrength2;
	    float fog_distance = fog_sunrise + fog_normal + fog_midnight + fog_rain;
	
	    // get fog color. 
	    vec3 fogclr_sun = vec3(0.25,0.7,1.5)*0.2*(TimeSunrise+TimeSunset)*(1.0-rainStrength2*1.0);
	    vec3 fogclr_noon = vec3(0.2,0.7,1.5)*TimeNoon*(1.0-rainStrength2*1.0);
	    vec3 fogclr_midnight = vec3(0.1, 0.4, 1.0)*0.05*TimeMidnight*(1.0-rainStrength2*0.1);
	    vec3 fogclr_rain = vec3(0.5,0.9,1.0)*0.1*(1.0-TimeMidnight*1.0)*rainStrength2;
	    vec3 fogclr = fogclr_sun + fogclr_noon + fogclr_midnight + fogclr_rain;
		fogclr *= (eyeBrightnessSmooth.y/255.0);
	 
	if (land > 0.9) {
	    float depth_diff2 = clamp(exp(-length(fragpos)/fog_distance)+0.25,0.0,1.0);
	    float fogfactor =  clamp(depth_diff2 + hand,0.0,1.0);
	    color.rgb += mix(fogclr*0.1+pow(volumetric_cone,15.0)*0.2*suncolor,color.rgb,fogfactor);
	}
		
	#endif
	
/* DRAWBUFFERS:31 */


#ifdef CEL_SHADING
	if (land > 0.9 && iswater < 0.9) color = celshade(color);
#endif



#ifdef GODRAYS
	
	const float gr_density = 0.5;			
	const int gr_samples = 7;
	const float gr_noise = 0.0;
	
	float gr = 0.0;
	
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.5);		//temporary fix that check if the sun/moon position is correct
	
	if (truepos > 0.05) {	
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(gr_samples) * gr_density;
	
			float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
			vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
			
			for(int i=0; i < gr_samples ; i++) {			
				textCoord -= deltaTextCoord;
				float sample = step(texture2D(gaux1, textCoord+ textCoord*noise*gr_noise).g,0.01);
				gr += sample;
		}
	}
	
#endif

	color = pow(color,vec3(1.0/2.2));
	color = clamp(color,0.0,1.0);
	gl_FragData[0] = vec4(color, 0.0);
	#ifdef GODRAYS
	gl_FragData[1] = vec4(vec3((gr/gr_samples)),1.0);
	#endif
	
}
